logging.controllers.module('logs-overview',
	['xhr', 'loading_spinner'],
	() => {
		return {
			vue: true,
			name: 'gx-logs-overview',
			template: '#logs-overview',
			data: () => ({
				logs: [],
				logfiles: [],
				selectedLogCategory: '',
				selectedLogFileIndex: 0,
				maxSelectableLogFiles: 0,
				minLogLevel: 300,
				displayedLogLevels: [
					'DEBUG',
					'INFO',
					'NOTICE',
					'WARNING',
					'ERROR',
					'CRITICAL',
					'ALERT',
					'EMERGENCY',
				],
				showNoLogsAvailable: true,
				deleteSelectedLogfileModalActive: false,
				lang: {
					labels: {
						noLogsToShow: jse.core.lang.translate('labels_no_logs_to_show', 'logging'),
						category: jse.core.lang.translate('labels_category', 'logging'),
						file: jse.core.lang.translate('labels_file', 'logging'),
						logLevel: jse.core.lang.translate('labels_log_level', 'logging'),
						logLevels: {
							debug: jse.core.lang.translate('labels_log_levels_debug', 'logging'),
							info: jse.core.lang.translate('labels_log_levels_info', 'logging'),
							notice: jse.core.lang.translate('labels_log_levels_notice', 'logging'),
							warning: jse.core.lang.translate('labels_log_levels_warning', 'logging'),
							error: jse.core.lang.translate('labels_log_levels_error', 'logging'),
							critical: jse.core.lang.translate('labels_log_levels_critical', 'logging'),
							alert: jse.core.lang.translate('labels_log_levels_alert', 'logging'),
							emergency: jse.core.lang.translate('labels_log_levels_emergency', 'logging'),
						},
					},
					buttons: {
						deleteSelectedCategory: jse.core.lang.translate('buttons_delete_selected_category', 'logging'),
						deleteOldLogs: jse.core.lang.translate('buttons_delete_old_logs', 'logging'),
						deleteAllLogs: jse.core.lang.translate('buttons_delete_all_logs', 'logging'),
						showNextLogFile: jse.core.lang.translate('buttons_show_next_log_file', 'logging'),
					},
					modals: {
						deleteSingleLogfile: {
							title: jse.core.lang.translate('modal_title_delete_log_files_by_category', 'logging'),
							text: jse.core.lang.translate('modal_text_delete_log_files_by_category', 'logging'),
							close: jse.core.lang.translate('close', 'buttons'),
							confirm: jse.core.lang.translate('delete', 'buttons'),
						},
						deleteOldLogfiles: {
							title: jse.core.lang.translate('modal_title_delete_old_log_files', 'logging'),
							text: jse.core.lang.translate('modal_text_delete_old_log_files', 'logging'),
							days: jse.core.lang.translate('modal_label_delete_old_log_files_days', 'logging'),
							age: jse.core.lang.translate('modal_label_delete_old_log_files_age', 'logging'),
							close: jse.core.lang.translate('close', 'buttons'),
							confirm: jse.core.lang.translate('delete', 'buttons'),
						},
						deleteAllLogfiles: {
							title: jse.core.lang.translate('modal_title_delete_all_log_files', 'logging'),
							text: jse.core.lang.translate('modal_text_delete_all_log_files', 'logging'),
							close: jse.core.lang.translate('close', 'buttons'),
							confirm: jse.core.lang.translate('delete', 'buttons'),
						},
					},
				},
				days: 14,
			}),
			methods: {
				loadLogfiles() {
					const vm = this;
					const $target = $('.logs-overview');
					const spinner = jse.libs.loading_spinner.show($target);
					this.logfiles = [];
					this.selectedLogFileIndex = 0;
					this.selectedLogCategory = '';
					this.maxSelectableLogFiles = 0;
					
					jse.libs.xhr.get({url: './admin.php?do=Logging/GetLogfiles'}).done(response => {
						if (response.logfiles === undefined || response.logfiles.length === 0) {
							vm.logfiles = {};
							vm.selectedLogFileIndex = 0;
							vm.selectedLogCategory = '';
							vm.maxSelectableLogFiles = 0;
							vm.logs = [];
							vm.showNoLogsAvailable = true;
							jse.libs.loading_spinner.hide(spinner);
							return;
						}
						
						vm.logfiles = response.logfiles;
						vm.selectedLogFileIndex = 0;
						vm.selectedLogCategory = Object.keys(response.logfiles)[0];
						vm.maxSelectableLogFiles = (vm.logfiles[vm.selectedLogCategory]).length - 1;
						vm.loadLogs();
						
						jse.libs.loading_spinner.hide(spinner);
					}).fail(response => console.error(response));
				},
				loadLogs() {
					const vm = this;
					const $target = $('.logs-overview');
					const spinner = jse.libs.loading_spinner.show($target);
					const logFile = this.logfiles[this.selectedLogCategory][this.selectedLogFileIndex];
					this.logs = [];
					
					jse.libs.xhr.get({url: './admin.php?do=Logging/GetLogs&logfile=' + logFile})
						.done(response => {
							for (const log of response.logs) {
								try {
									vm.logs.push(JSON.parse(log));
								} catch (error) {
									$('.message-stack').append(`
										<div class="alert alert-danger">
										<button type="button" class="close" data-dismiss="alert">×</button>
										` + jse.core.lang.translate('labels_json_error_first_part', 'logging')
										+ logFile
										+ jse.core.lang.translate('labels_json_error_last_part', 'logging') + `
										</div>
									`);
								}
							}
							vm.checkForNoLogsNotice();
							jse.libs.loading_spinner.hide(spinner);
						})
						.fail(response => console.error(response));
				},
				checkForNoLogsNotice() {
					this.showNoLogsAvailable = true;
					for (const log of this.logs) {
						if (this.displayedLogLevels.includes(log.level_name)) {
							this.showNoLogsAvailable = false;
						}
					}
				},
				changedLogCategory() {
					this.maxSelectableLogFiles = this.logfiles[this.selectedLogCategory].length - 1;
					this.selectedLogFileIndex = 0;
					this.loadLogs();
				},
				showNextLogFile() {
					$('html, body').animate({
						scrollTop: 0
					});
					this.selectedLogFileIndex++;
					this.loadLogs();
				},
				showDeleteSelectedLogfileModal() {
					$('.delete-single-log.modal').modal('show');
				},
				deleteSelectedLogfile() {
					const vm = this;
					const selected = this.logfiles[this.selectedLogCategory][0];
					
					jse.libs.xhr.post({
						url: './admin.php?do=Logging/DeleteSelectedLogs',
						data: {selected: selected}
					}).done(response => {
						vm.loadLogfiles();
					}).fail(response => console.error(response, 'Could not delete selected logs: '
						+ this.selectedLogCategory));
					
					$('.delete-single-log.modal').modal('hide');
				},
				showDeleteOldLogfilesModal() {
					$('.delete-old-logs.modal').modal('show');
				},
				deleteOldLogfiles() {
					const vm = this;
					
					jse.libs.xhr.post({
						url: './admin.php?do=Logging/DeleteOldLogfiles',
						data: {days: this.days}
					}).done(response => {
						vm.loadLogfiles();
					}).fail(response => console.error(response, 'Could not delete old logs'));
					
					$('.delete-old-logs.modal').modal('hide');
				},
				showDeleteAllLogfilesModal() {
					$('.delete-all-logs.modal').modal('show');
				},
				deleteAllLogfiles() {
					const vm = this;
					
					jse.libs.xhr.post({url: './admin.php?do=Logging/DeleteAllLogfiles'}).done(response => {
						vm.loadLogfiles();
					}).fail(response => console.error(response, 'Could not delete all log files'));
					
					$('.delete-all-logs.modal').modal('hide');
				}
			},
			mounted() {
				this.loadLogfiles();
			},
			init: done => done()
		}
	});